/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.server.DeleteServerDialog;

public class ServerDeleteAction
extends SelectionProviderAction {
    private List<IServer> servers;
    private Shell shell;

    public ServerDeleteAction(Shell shell, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionDelete);
        this.shell = shell;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.servers = new ArrayList<IServer>();
        boolean enabled = false;
        for (Object obj : sel) {
            if (obj instanceof IServer) {
                IServer server = (IServer)obj;
                this.servers.add(server);
                enabled = true;
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        IStructuredSelection sel;
        if (this.servers == null && (sel = this.getStructuredSelection()) != null) {
            this.selectionChanged(sel);
        }
        if (this.servers != null) {
            DeleteServerDialog dsd = new DeleteServerDialog(this.shell, this.servers);
            dsd.open();
        }
    }
}

